import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as Shared from "../../shared.js";
import * as RequestsAPI from "./requests.js";
export declare class PriorityResource extends APIResource {
    /**
     * Create a New Priority Intelligence Requirement
     */
    create(accountIdentifier: string, body: PriorityCreateParams, options?: Core.RequestOptions): Core.APIPromise<Priority>;
    /**
     * Update a Priority Intelligence Requirement
     */
    update(accountIdentifier: string, priorityIdentifer: string, body: PriorityUpdateParams, options?: Core.RequestOptions): Core.APIPromise<RequestsAPI.Item>;
    /**
     * Delete a Priority Intelligence Requirement
     */
    delete(accountIdentifier: string, priorityIdentifer: string, options?: Core.RequestOptions): Core.APIPromise<PriorityDeleteResponse>;
    /**
     * Get a Priority Intelligence Requirement
     */
    get(accountIdentifier: string, priorityIdentifer: string, options?: Core.RequestOptions): Core.APIPromise<RequestsAPI.Item>;
    /**
     * Get Priority Intelligence Requirement Quota
     */
    quota(accountIdentifier: string, options?: Core.RequestOptions): Core.APIPromise<RequestsAPI.Quota>;
}
export type Label = string;
export type LabelParam = string;
export interface Priority {
    /**
     * UUID
     */
    id: string;
    /**
     * Priority creation time
     */
    created: string;
    /**
     * List of labels
     */
    labels: Array<Label>;
    /**
     * Priority
     */
    priority: number;
    /**
     * Requirement
     */
    requirement: string;
    /**
     * The CISA defined Traffic Light Protocol (TLP)
     */
    tlp: 'clear' | 'amber' | 'amber-strict' | 'green' | 'red';
    /**
     * Priority last updated time
     */
    updated: string;
}
export interface PriorityEdit {
    /**
     * List of labels
     */
    labels: Array<Label>;
    /**
     * Priority
     */
    priority: number;
    /**
     * Requirement
     */
    requirement: string;
    /**
     * The CISA defined Traffic Light Protocol (TLP)
     */
    tlp: 'clear' | 'amber' | 'amber-strict' | 'green' | 'red';
}
export interface PriorityDeleteResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
}
export interface PriorityCreateParams {
    /**
     * List of labels
     */
    labels: Array<LabelParam>;
    /**
     * Priority
     */
    priority: number;
    /**
     * Requirement
     */
    requirement: string;
    /**
     * The CISA defined Traffic Light Protocol (TLP)
     */
    tlp: 'clear' | 'amber' | 'amber-strict' | 'green' | 'red';
}
export interface PriorityUpdateParams {
    /**
     * List of labels
     */
    labels: Array<LabelParam>;
    /**
     * Priority
     */
    priority: number;
    /**
     * Requirement
     */
    requirement: string;
    /**
     * The CISA defined Traffic Light Protocol (TLP)
     */
    tlp: 'clear' | 'amber' | 'amber-strict' | 'green' | 'red';
}
export declare namespace PriorityResource {
    export { type Label as Label, type Priority as Priority, type PriorityEdit as PriorityEdit, type PriorityDeleteResponse as PriorityDeleteResponse, type PriorityCreateParams as PriorityCreateParams, type PriorityUpdateParams as PriorityUpdateParams, };
}
//# sourceMappingURL=priority.d.ts.map