// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class PriorityResource extends APIResource {
    /**
     * Create a New Priority Intelligence Requirement
     */
    create(accountIdentifier, body, options) {
        return this._client.post(`/accounts/${accountIdentifier}/cloudforce-one/requests/priority/new`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Priority Intelligence Requirement
     */
    update(accountIdentifier, priorityIdentifer, body, options) {
        return this._client.put(`/accounts/${accountIdentifier}/cloudforce-one/requests/priority/${priorityIdentifer}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete a Priority Intelligence Requirement
     */
    delete(accountIdentifier, priorityIdentifer, options) {
        return this._client.delete(`/accounts/${accountIdentifier}/cloudforce-one/requests/priority/${priorityIdentifer}`, options);
    }
    /**
     * Get a Priority Intelligence Requirement
     */
    get(accountIdentifier, priorityIdentifer, options) {
        return this._client.get(`/accounts/${accountIdentifier}/cloudforce-one/requests/priority/${priorityIdentifer}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Priority Intelligence Requirement Quota
     */
    quota(accountIdentifier, options) {
        return this._client.get(`/accounts/${accountIdentifier}/cloudforce-one/requests/priority/quota`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=priority.mjs.map