import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as Shared from "../../shared.js";
import * as AssetsAPI from "./assets.js";
import { AssetCreateParams, AssetCreateResponse, AssetCreateResponsesSinglePage, AssetDeleteResponse, AssetGetResponse, AssetGetResponsesSinglePage, AssetUpdateParams, AssetUpdateResponse, Assets } from "./assets.js";
import * as MessageAPI from "./message.js";
import { Message, MessageCreateParams, MessageDeleteResponse, MessageGetParams, MessageResource, MessageUpdateParams, MessagesSinglePage } from "./message.js";
import * as PriorityAPI from "./priority.js";
import { Label, Priority, PriorityCreateParams, PriorityDeleteResponse, PriorityEdit, PriorityResource, PriorityUpdateParams } from "./priority.js";
import { SinglePage } from "../../../pagination.js";
export declare class Requests extends APIResource {
    message: MessageAPI.MessageResource;
    priority: PriorityAPI.PriorityResource;
    assets: AssetsAPI.Assets;
    /**
     * Creating a request adds the request into the Cloudforce One queue for analysis.
     * In addition to the content, a short title, type, priority, and releasability
     * should be provided. If one is not provided, a default will be assigned.
     */
    create(accountIdentifier: string, body: RequestCreateParams, options?: Core.RequestOptions): Core.APIPromise<Item>;
    /**
     * Updating a request alters the request in the Cloudforce One queue. This API may
     * be used to update any attributes of the request after the initial submission.
     * Only fields that you choose to update need to be add to the request body.
     */
    update(accountIdentifier: string, requestIdentifier: string, body: RequestUpdateParams, options?: Core.RequestOptions): Core.APIPromise<Item>;
    /**
     * List Requests
     */
    list(accountIdentifier: string, body: RequestListParams, options?: Core.RequestOptions): Core.PagePromise<ListItemsSinglePage, ListItem>;
    /**
     * Delete a Request
     */
    delete(accountIdentifier: string, requestIdentifier: string, options?: Core.RequestOptions): Core.APIPromise<RequestDeleteResponse>;
    /**
     * Get Request Priority, Status, and TLP constants
     */
    constants(accountIdentifier: string, options?: Core.RequestOptions): Core.APIPromise<RequestConstants>;
    /**
     * Get a Request
     */
    get(accountIdentifier: string, requestIdentifier: string, options?: Core.RequestOptions): Core.APIPromise<Item>;
    /**
     * Get Request Quota
     */
    quota(accountIdentifier: string, options?: Core.RequestOptions): Core.APIPromise<Quota>;
    /**
     * Get Request Types
     */
    types(accountIdentifier: string, options?: Core.RequestOptions): Core.PagePromise<RequestTypesResponsesSinglePage, RequestTypesResponse>;
}
export declare class ListItemsSinglePage extends SinglePage<ListItem> {
}
export declare class RequestTypesResponsesSinglePage extends SinglePage<RequestTypesResponse> {
}
export interface Item {
    /**
     * UUID
     */
    id: string;
    /**
     * Request content
     */
    content: string;
    created: string;
    priority: string;
    /**
     * Requested information from request
     */
    request: string;
    /**
     * Brief description of the request
     */
    summary: string;
    /**
     * The CISA defined Traffic Light Protocol (TLP)
     */
    tlp: 'clear' | 'amber' | 'amber-strict' | 'green' | 'red';
    updated: string;
    completed?: string;
    /**
     * Tokens for the request messages
     */
    message_tokens?: number;
    /**
     * Readable Request ID
     */
    readable_id?: string;
    /**
     * Request Status
     */
    status?: 'open' | 'accepted' | 'reported' | 'approved' | 'completed' | 'declined';
    /**
     * Tokens for the request
     */
    tokens?: number;
}
export interface ListItem {
    /**
     * UUID
     */
    id: string;
    /**
     * Request creation time
     */
    created: string;
    priority: 'routine' | 'high' | 'urgent';
    /**
     * Requested information from request
     */
    request: string;
    /**
     * Brief description of the request
     */
    summary: string;
    /**
     * The CISA defined Traffic Light Protocol (TLP)
     */
    tlp: 'clear' | 'amber' | 'amber-strict' | 'green' | 'red';
    /**
     * Request last updated time
     */
    updated: string;
    /**
     * Request completion time
     */
    completed?: string;
    /**
     * Tokens for the request messages
     */
    message_tokens?: number;
    /**
     * Readable Request ID
     */
    readable_id?: string;
    /**
     * Request Status
     */
    status?: 'open' | 'accepted' | 'reported' | 'approved' | 'completed' | 'declined';
    /**
     * Tokens for the request
     */
    tokens?: number;
}
export interface Quota {
    /**
     * Anniversary date is when annual quota limit is refresh
     */
    anniversary_date?: string;
    /**
     * Quater anniversary date is when quota limit is refreshed each quarter
     */
    quarter_anniversary_date?: string;
    /**
     * Tokens for the quarter
     */
    quota?: number;
    /**
     * Tokens remaining for the quarter
     */
    remaining?: number;
}
export interface RequestConstants {
    priority?: Array<'routine' | 'high' | 'urgent'>;
    status?: Array<'open' | 'accepted' | 'reported' | 'approved' | 'completed' | 'declined'>;
    tlp?: Array<'clear' | 'amber' | 'amber-strict' | 'green' | 'red'>;
}
export type RequestTypes = Array<RequestTypesResponse>;
export interface RequestDeleteResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
}
/**
 * Request Types
 */
export type RequestTypesResponse = string;
export interface RequestCreateParams {
    /**
     * Request content
     */
    content?: string;
    /**
     * Priority for analyzing the request
     */
    priority?: string;
    /**
     * Requested information from request
     */
    request_type?: string;
    /**
     * Brief description of the request
     */
    summary?: string;
    /**
     * The CISA defined Traffic Light Protocol (TLP)
     */
    tlp?: 'clear' | 'amber' | 'amber-strict' | 'green' | 'red';
}
export interface RequestUpdateParams {
    /**
     * Request content
     */
    content?: string;
    /**
     * Priority for analyzing the request
     */
    priority?: string;
    /**
     * Requested information from request
     */
    request_type?: string;
    /**
     * Brief description of the request
     */
    summary?: string;
    /**
     * The CISA defined Traffic Light Protocol (TLP)
     */
    tlp?: 'clear' | 'amber' | 'amber-strict' | 'green' | 'red';
}
export interface RequestListParams {
    /**
     * Page number of results
     */
    page: number;
    /**
     * Number of results per page
     */
    per_page: number;
    /**
     * Retrieve requests completed after this time
     */
    completed_after?: string;
    /**
     * Retrieve requests completed before this time
     */
    completed_before?: string;
    /**
     * Retrieve requests created after this time
     */
    created_after?: string;
    /**
     * Retrieve requests created before this time
     */
    created_before?: string;
    /**
     * Requested information from request
     */
    request_type?: string;
    /**
     * Field to sort results by
     */
    sort_by?: string;
    /**
     * Sort order (asc or desc)
     */
    sort_order?: 'asc' | 'desc';
    /**
     * Request Status
     */
    status?: 'open' | 'accepted' | 'reported' | 'approved' | 'completed' | 'declined';
}
export declare namespace Requests {
    export { type Item as Item, type ListItem as ListItem, type Quota as Quota, type RequestConstants as RequestConstants, type RequestTypes as RequestTypes, type RequestDeleteResponse as RequestDeleteResponse, type RequestTypesResponse as RequestTypesResponse, ListItemsSinglePage as ListItemsSinglePage, RequestTypesResponsesSinglePage as RequestTypesResponsesSinglePage, type RequestCreateParams as RequestCreateParams, type RequestUpdateParams as RequestUpdateParams, type RequestListParams as RequestListParams, };
    export { MessageResource as MessageResource, type Message as Message, type MessageDeleteResponse as MessageDeleteResponse, MessagesSinglePage as MessagesSinglePage, type MessageCreateParams as MessageCreateParams, type MessageUpdateParams as MessageUpdateParams, type MessageGetParams as MessageGetParams, };
    export { PriorityResource as PriorityResource, type Label as Label, type Priority as Priority, type PriorityEdit as PriorityEdit, type PriorityDeleteResponse as PriorityDeleteResponse, type PriorityCreateParams as PriorityCreateParams, type PriorityUpdateParams as PriorityUpdateParams, };
    export { Assets as Assets, type AssetCreateResponse as AssetCreateResponse, type AssetUpdateResponse as AssetUpdateResponse, type AssetDeleteResponse as AssetDeleteResponse, type AssetGetResponse as AssetGetResponse, AssetCreateResponsesSinglePage as AssetCreateResponsesSinglePage, AssetGetResponsesSinglePage as AssetGetResponsesSinglePage, type AssetCreateParams as AssetCreateParams, type AssetUpdateParams as AssetUpdateParams, };
}
//# sourceMappingURL=requests.d.ts.map