"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestTypesResponsesSinglePage = exports.ListItemsSinglePage = exports.Requests = void 0;
const resource_1 = require("../../../resource.js");
const AssetsAPI = __importStar(require("./assets.js"));
const assets_1 = require("./assets.js");
const MessageAPI = __importStar(require("./message.js"));
const message_1 = require("./message.js");
const PriorityAPI = __importStar(require("./priority.js"));
const priority_1 = require("./priority.js");
const pagination_1 = require("../../../pagination.js");
class Requests extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.message = new MessageAPI.MessageResource(this._client);
        this.priority = new PriorityAPI.PriorityResource(this._client);
        this.assets = new AssetsAPI.Assets(this._client);
    }
    /**
     * Creating a request adds the request into the Cloudforce One queue for analysis.
     * In addition to the content, a short title, type, priority, and releasability
     * should be provided. If one is not provided, a default will be assigned.
     */
    create(accountIdentifier, body, options) {
        return this._client.post(`/accounts/${accountIdentifier}/cloudforce-one/requests/new`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updating a request alters the request in the Cloudforce One queue. This API may
     * be used to update any attributes of the request after the initial submission.
     * Only fields that you choose to update need to be add to the request body.
     */
    update(accountIdentifier, requestIdentifier, body, options) {
        return this._client.put(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Requests
     */
    list(accountIdentifier, body, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests`, ListItemsSinglePage, { body, method: 'post', ...options });
    }
    /**
     * Delete a Request
     */
    delete(accountIdentifier, requestIdentifier, options) {
        return this._client.delete(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}`, options);
    }
    /**
     * Get Request Priority, Status, and TLP constants
     */
    constants(accountIdentifier, options) {
        return this._client.get(`/accounts/${accountIdentifier}/cloudforce-one/requests/constants`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a Request
     */
    get(accountIdentifier, requestIdentifier, options) {
        return this._client.get(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Request Quota
     */
    quota(accountIdentifier, options) {
        return this._client.get(`/accounts/${accountIdentifier}/cloudforce-one/requests/quota`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Request Types
     */
    types(accountIdentifier, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests/types`, RequestTypesResponsesSinglePage, options);
    }
}
exports.Requests = Requests;
class ListItemsSinglePage extends pagination_1.SinglePage {
}
exports.ListItemsSinglePage = ListItemsSinglePage;
class RequestTypesResponsesSinglePage extends pagination_1.SinglePage {
}
exports.RequestTypesResponsesSinglePage = RequestTypesResponsesSinglePage;
Requests.ListItemsSinglePage = ListItemsSinglePage;
Requests.RequestTypesResponsesSinglePage = RequestTypesResponsesSinglePage;
Requests.MessageResource = message_1.MessageResource;
Requests.MessagesSinglePage = message_1.MessagesSinglePage;
Requests.PriorityResource = priority_1.PriorityResource;
Requests.Assets = assets_1.Assets;
Requests.AssetCreateResponsesSinglePage = assets_1.AssetCreateResponsesSinglePage;
Requests.AssetGetResponsesSinglePage = assets_1.AssetGetResponsesSinglePage;
//# sourceMappingURL=requests.js.map