// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as AssetsAPI from "./assets.mjs";
import { AssetCreateResponsesSinglePage, AssetGetResponsesSinglePage, Assets, } from "./assets.mjs";
import * as MessageAPI from "./message.mjs";
import { MessageResource, MessagesSinglePage, } from "./message.mjs";
import * as PriorityAPI from "./priority.mjs";
import { PriorityResource, } from "./priority.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Requests extends APIResource {
    constructor() {
        super(...arguments);
        this.message = new MessageAPI.MessageResource(this._client);
        this.priority = new PriorityAPI.PriorityResource(this._client);
        this.assets = new AssetsAPI.Assets(this._client);
    }
    /**
     * Creating a request adds the request into the Cloudforce One queue for analysis.
     * In addition to the content, a short title, type, priority, and releasability
     * should be provided. If one is not provided, a default will be assigned.
     */
    create(accountIdentifier, body, options) {
        return this._client.post(`/accounts/${accountIdentifier}/cloudforce-one/requests/new`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updating a request alters the request in the Cloudforce One queue. This API may
     * be used to update any attributes of the request after the initial submission.
     * Only fields that you choose to update need to be add to the request body.
     */
    update(accountIdentifier, requestIdentifier, body, options) {
        return this._client.put(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Requests
     */
    list(accountIdentifier, body, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests`, ListItemsSinglePage, { body, method: 'post', ...options });
    }
    /**
     * Delete a Request
     */
    delete(accountIdentifier, requestIdentifier, options) {
        return this._client.delete(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}`, options);
    }
    /**
     * Get Request Priority, Status, and TLP constants
     */
    constants(accountIdentifier, options) {
        return this._client.get(`/accounts/${accountIdentifier}/cloudforce-one/requests/constants`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a Request
     */
    get(accountIdentifier, requestIdentifier, options) {
        return this._client.get(`/accounts/${accountIdentifier}/cloudforce-one/requests/${requestIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Request Quota
     */
    quota(accountIdentifier, options) {
        return this._client.get(`/accounts/${accountIdentifier}/cloudforce-one/requests/quota`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Request Types
     */
    types(accountIdentifier, options) {
        return this._client.getAPIList(`/accounts/${accountIdentifier}/cloudforce-one/requests/types`, RequestTypesResponsesSinglePage, options);
    }
}
export class ListItemsSinglePage extends SinglePage {
}
export class RequestTypesResponsesSinglePage extends SinglePage {
}
Requests.ListItemsSinglePage = ListItemsSinglePage;
Requests.RequestTypesResponsesSinglePage = RequestTypesResponsesSinglePage;
Requests.MessageResource = MessageResource;
Requests.MessagesSinglePage = MessagesSinglePage;
Requests.PriorityResource = PriorityResource;
Requests.Assets = Assets;
Requests.AssetCreateResponsesSinglePage = AssetCreateResponsesSinglePage;
Requests.AssetGetResponsesSinglePage = AssetGetResponsesSinglePage;
//# sourceMappingURL=requests.mjs.map