import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class Config extends APIResource {
    /**
     * Create a new Scan Config
     */
    create(params: ConfigCreateParams, options?: Core.RequestOptions): Core.APIPromise<ConfigCreateResponse>;
    /**
     * List Scan Configs
     */
    list(params: ConfigListParams, options?: Core.RequestOptions): Core.PagePromise<ConfigListResponsesSinglePage, ConfigListResponse>;
    /**
     * Delete a Scan Config
     */
    delete(configId: string, params: ConfigDeleteParams, options?: Core.RequestOptions): Core.APIPromise<ConfigDeleteResponse>;
    /**
     * Update an existing Scan Config
     */
    edit(configId: string, params: ConfigEditParams, options?: Core.RequestOptions): Core.APIPromise<ConfigEditResponse>;
}
export declare class ConfigListResponsesSinglePage extends SinglePage<ConfigListResponse> {
}
export interface ConfigCreateResponse {
    /**
     * Config ID
     */
    id: string;
    account_id: string;
    /**
     * The number of days between each scan (0 = no recurring scans).
     */
    frequency: number;
    /**
     * A list of IP addresses or CIDR blocks to scan. The maximum number of total IP
     * addresses allowed is 5000.
     */
    ips: Array<string>;
    /**
     * A list of ports to scan. Allowed values:"default", "all", or a comma-separated
     * list of ports or range of ports (e.g. ["1-80", "443"]). Default will scan the
     * 100 most commonly open ports.
     */
    ports: Array<string>;
}
export interface ConfigListResponse {
    /**
     * Config ID
     */
    id: string;
    account_id: string;
    /**
     * The number of days between each scan (0 = no recurring scans).
     */
    frequency: number;
    /**
     * A list of IP addresses or CIDR blocks to scan. The maximum number of total IP
     * addresses allowed is 5000.
     */
    ips: Array<string>;
    /**
     * A list of ports to scan. Allowed values:"default", "all", or a comma-separated
     * list of ports or range of ports (e.g. ["1-80", "443"]). Default will scan the
     * 100 most commonly open ports.
     */
    ports: Array<string>;
}
export type ConfigDeleteResponse = unknown;
export interface ConfigEditResponse {
    /**
     * Config ID
     */
    id: string;
    account_id: string;
    /**
     * The number of days between each scan (0 = no recurring scans).
     */
    frequency: number;
    /**
     * A list of IP addresses or CIDR blocks to scan. The maximum number of total IP
     * addresses allowed is 5000.
     */
    ips: Array<string>;
    /**
     * A list of ports to scan. Allowed values:"default", "all", or a comma-separated
     * list of ports or range of ports (e.g. ["1-80", "443"]). Default will scan the
     * 100 most commonly open ports.
     */
    ports: Array<string>;
}
export interface ConfigCreateParams {
    /**
     * Path param: Account ID
     */
    account_id: string;
    /**
     * Body param: A list of IP addresses or CIDR blocks to scan. The maximum number of
     * total IP addresses allowed is 5000.
     */
    ips: Array<string>;
    /**
     * Body param: The number of days between each scan (0 = no recurring scans).
     */
    frequency?: number;
    /**
     * Body param: A list of ports to scan. Allowed values:"default", "all", or a
     * comma-separated list of ports or range of ports (e.g. ["1-80", "443"]). Default
     * will scan the 100 most commonly open ports.
     */
    ports?: Array<string>;
}
export interface ConfigListParams {
    /**
     * Account ID
     */
    account_id: string;
}
export interface ConfigDeleteParams {
    /**
     * Account ID
     */
    account_id: string;
}
export interface ConfigEditParams {
    /**
     * Path param: Account ID
     */
    account_id: string;
    /**
     * Body param: The number of days between each scan (0 = no recurring scans).
     */
    frequency?: number;
    /**
     * Body param: A list of IP addresses or CIDR blocks to scan. The maximum number of
     * total IP addresses allowed is 5000.
     */
    ips?: Array<string>;
    /**
     * Body param: A list of ports to scan. Allowed values:"default", "all", or a
     * comma-separated list of ports or range of ports (e.g. ["1-80", "443"]). Default
     * will scan the 100 most commonly open ports.
     */
    ports?: Array<string>;
}
export declare namespace Config {
    export { type ConfigCreateResponse as ConfigCreateResponse, type ConfigListResponse as ConfigListResponse, type ConfigDeleteResponse as ConfigDeleteResponse, type ConfigEditResponse as ConfigEditResponse, ConfigListResponsesSinglePage as ConfigListResponsesSinglePage, type ConfigCreateParams as ConfigCreateParams, type ConfigListParams as ConfigListParams, type ConfigDeleteParams as ConfigDeleteParams, type ConfigEditParams as ConfigEditParams, };
}
//# sourceMappingURL=config.d.ts.map