"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigListResponsesSinglePage = exports.Config = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Config extends resource_1.APIResource {
    /**
     * Create a new Scan Config
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cloudforce-one/scans/config`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Scan Configs
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/cloudforce-one/scans/config`, ConfigListResponsesSinglePage, options);
    }
    /**
     * Delete a Scan Config
     */
    delete(configId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/cloudforce-one/scans/config/${configId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update an existing Scan Config
     */
    edit(configId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/cloudforce-one/scans/config/${configId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Config = Config;
class ConfigListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.ConfigListResponsesSinglePage = ConfigListResponsesSinglePage;
Config.ConfigListResponsesSinglePage = ConfigListResponsesSinglePage;
//# sourceMappingURL=config.js.map