// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Config extends APIResource {
    /**
     * Create a new Scan Config
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cloudforce-one/scans/config`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Scan Configs
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/cloudforce-one/scans/config`, ConfigListResponsesSinglePage, options);
    }
    /**
     * Delete a Scan Config
     */
    delete(configId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/cloudforce-one/scans/config/${configId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update an existing Scan Config
     */
    edit(configId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/cloudforce-one/scans/config/${configId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
export class ConfigListResponsesSinglePage extends SinglePage {
}
Config.ConfigListResponsesSinglePage = ConfigListResponsesSinglePage;
//# sourceMappingURL=config.mjs.map