import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Categories extends APIResource {
    /**
     * Creates a new category
     */
    create(params: CategoryCreateParams, options?: Core.RequestOptions): Core.APIPromise<CategoryCreateResponse>;
    /**
     * Lists categories
     */
    list(params: CategoryListParams, options?: Core.RequestOptions): Core.APIPromise<CategoryListResponse>;
    /**
     * Deletes a category
     */
    delete(categoryId: string, params: CategoryDeleteParams, options?: Core.RequestOptions): Core.APIPromise<CategoryDeleteResponse>;
    /**
     * Updates a category
     */
    edit(categoryId: string, params: CategoryEditParams, options?: Core.RequestOptions): Core.APIPromise<CategoryEditResponse>;
    /**
     * Reads a category
     */
    get(categoryId: string, params: CategoryGetParams, options?: Core.RequestOptions): Core.APIPromise<CategoryGetResponse>;
}
export interface CategoryCreateResponse {
    killChain: number;
    name: string;
    uuid: string;
    mitreAttack?: Array<string>;
    shortname?: string;
}
export type CategoryListResponse = Array<CategoryListResponse.CategoryListResponseItem>;
export declare namespace CategoryListResponse {
    interface CategoryListResponseItem {
        killChain: number;
        name: string;
        uuid: string;
        mitreAttack?: Array<string>;
        shortname?: string;
    }
}
export interface CategoryDeleteResponse {
    uuid: string;
}
export interface CategoryEditResponse {
    killChain: number;
    name: string;
    uuid: string;
    mitreAttack?: Array<string>;
    shortname?: string;
}
export interface CategoryGetResponse {
    killChain: number;
    name: string;
    uuid: string;
    mitreAttack?: Array<string>;
    shortname?: string;
}
export interface CategoryCreateParams {
    /**
     * Path param: Account ID
     */
    account_id: number;
    /**
     * Body param:
     */
    killChain: number;
    /**
     * Body param:
     */
    name: string;
    /**
     * Body param:
     */
    mitreAttack?: Array<string>;
    /**
     * Body param:
     */
    shortname?: string;
}
export interface CategoryListParams {
    /**
     * Account ID
     */
    account_id: number;
}
export interface CategoryDeleteParams {
    /**
     * Account ID
     */
    account_id: number;
}
export interface CategoryEditParams {
    /**
     * Path param: Account ID
     */
    account_id: number;
    /**
     * Body param:
     */
    killChain?: number;
    /**
     * Body param:
     */
    mitreAttack?: Array<string>;
    /**
     * Body param:
     */
    name?: string;
    /**
     * Body param:
     */
    shortname?: string;
}
export interface CategoryGetParams {
    /**
     * Account ID
     */
    account_id: number;
}
export declare namespace Categories {
    export { type CategoryCreateResponse as CategoryCreateResponse, type CategoryListResponse as CategoryListResponse, type CategoryDeleteResponse as CategoryDeleteResponse, type CategoryEditResponse as CategoryEditResponse, type CategoryGetResponse as CategoryGetResponse, type CategoryCreateParams as CategoryCreateParams, type CategoryListParams as CategoryListParams, type CategoryDeleteParams as CategoryDeleteParams, type CategoryEditParams as CategoryEditParams, type CategoryGetParams as CategoryGetParams, };
}
//# sourceMappingURL=categories.d.ts.map