"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Categories = void 0;
const resource_1 = require("../../../resource.js");
class Categories extends resource_1.APIResource {
    /**
     * Creates a new category
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cloudforce-one/events/categories/create`, {
            body,
            ...options,
        });
    }
    /**
     * Lists categories
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cloudforce-one/events/categories`, options);
    }
    /**
     * Deletes a category
     */
    delete(categoryId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/cloudforce-one/events/categories/${categoryId}`, options);
    }
    /**
     * Updates a category
     */
    edit(categoryId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/cloudforce-one/events/categories/${categoryId}`, {
            body,
            ...options,
        });
    }
    /**
     * Reads a category
     */
    get(categoryId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cloudforce-one/events/categories/${categoryId}`, options);
    }
}
exports.Categories = Categories;
//# sourceMappingURL=categories.js.map