// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Categories extends APIResource {
    /**
     * Creates a new category
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cloudforce-one/events/categories/create`, {
            body,
            ...options,
        });
    }
    /**
     * Lists categories
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cloudforce-one/events/categories`, options);
    }
    /**
     * Deletes a category
     */
    delete(categoryId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/cloudforce-one/events/categories/${categoryId}`, options);
    }
    /**
     * Updates a category
     */
    edit(categoryId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/cloudforce-one/events/categories/${categoryId}`, {
            body,
            ...options,
        });
    }
    /**
     * Reads a category
     */
    get(categoryId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cloudforce-one/events/categories/${categoryId}`, options);
    }
}
//# sourceMappingURL=categories.mjs.map