import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Datasets extends APIResource {
    /**
     * Creates a dataset
     */
    create(params: DatasetCreateParams, options?: Core.RequestOptions): Core.APIPromise<DatasetCreateResponse>;
    /**
     * Lists all datasets in an account
     */
    list(params: DatasetListParams, options?: Core.RequestOptions): Core.APIPromise<DatasetListResponse>;
    /**
     * Updates an existing dataset
     */
    edit(datasetId: string, params: DatasetEditParams, options?: Core.RequestOptions): Core.APIPromise<DatasetEditResponse>;
    /**
     * Reads a dataset
     */
    get(datasetId: string, params: DatasetGetParams, options?: Core.RequestOptions): Core.APIPromise<DatasetGetResponse>;
    /**
     * Reads data for a raw event
     */
    raw(datasetId: string, eventId: string, params: DatasetRawParams, options?: Core.RequestOptions): Core.APIPromise<DatasetRawResponse>;
}
export interface DatasetCreateResponse {
    isPublic: boolean;
    name: string;
    uuid: string;
}
export type DatasetListResponse = Array<DatasetListResponse.DatasetListResponseItem>;
export declare namespace DatasetListResponse {
    interface DatasetListResponseItem {
        isPublic: boolean;
        name: string;
        uuid: string;
    }
}
export interface DatasetEditResponse {
    isPublic: boolean;
    name: string;
    uuid: string;
}
export interface DatasetGetResponse {
    isPublic: boolean;
    name: string;
    uuid: string;
}
export interface DatasetRawResponse {
    id: string;
    accountId: number;
    created: string;
    data: unknown;
    source: string;
    tlp: string;
}
export interface DatasetCreateParams {
    /**
     * Path param: Account ID
     */
    account_id: number;
    /**
     * Body param: If true, then anyone can search the dataset. If false, then its
     * limited to the account.
     */
    isPublic: boolean;
    /**
     * Body param: Used to describe the dataset within the account context
     */
    name: string;
}
export interface DatasetListParams {
    /**
     * Account ID
     */
    account_id: number;
}
export interface DatasetEditParams {
    /**
     * Path param: Account ID
     */
    account_id: number;
    /**
     * Body param: If true, then anyone can search the dataset. If false, then its
     * limited to the account.
     */
    isPublic: boolean;
    /**
     * Body param: Used to describe the dataset within the account context
     */
    name: string;
}
export interface DatasetGetParams {
    /**
     * Account ID
     */
    account_id: number;
}
export interface DatasetRawParams {
    /**
     * Account ID
     */
    account_id: number;
}
export declare namespace Datasets {
    export { type DatasetCreateResponse as DatasetCreateResponse, type DatasetListResponse as DatasetListResponse, type DatasetEditResponse as DatasetEditResponse, type DatasetGetResponse as DatasetGetResponse, type DatasetRawResponse as DatasetRawResponse, type DatasetCreateParams as DatasetCreateParams, type DatasetListParams as DatasetListParams, type DatasetEditParams as DatasetEditParams, type DatasetGetParams as DatasetGetParams, type DatasetRawParams as DatasetRawParams, };
}
//# sourceMappingURL=datasets.d.ts.map