// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Datasets extends APIResource {
    /**
     * Creates a dataset
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cloudforce-one/events/dataset/create`, {
            body,
            ...options,
        });
    }
    /**
     * Lists all datasets in an account
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cloudforce-one/events/dataset`, options);
    }
    /**
     * Updates an existing dataset
     */
    edit(datasetId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/cloudforce-one/events/dataset/${datasetId}`, {
            body,
            ...options,
        });
    }
    /**
     * Reads a dataset
     */
    get(datasetId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cloudforce-one/events/dataset/${datasetId}`, options);
    }
    /**
     * Reads data for a raw event
     */
    raw(datasetId, eventId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cloudforce-one/events/raw/${datasetId}/${eventId}`, options);
    }
}
//# sourceMappingURL=datasets.mjs.map