import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class EventTags extends APIResource {
    /**
     * Adds a tag to an event
     */
    create(eventId: string, params: EventTagCreateParams, options?: Core.RequestOptions): Core.APIPromise<EventTagCreateResponse>;
    /**
     * Removes a tag from an event
     */
    delete(eventId: string, params: EventTagDeleteParams, options?: Core.RequestOptions): Core.APIPromise<EventTagDeleteResponse>;
}
export interface EventTagCreateResponse {
    success: boolean;
}
export interface EventTagDeleteResponse {
    success: boolean;
}
export interface EventTagCreateParams {
    /**
     * Path param: Account ID
     */
    account_id: number;
    /**
     * Body param:
     */
    tags: Array<string>;
}
export interface EventTagDeleteParams {
    /**
     * Account ID
     */
    account_id: number;
}
export declare namespace EventTags {
    export { type EventTagCreateResponse as EventTagCreateResponse, type EventTagDeleteResponse as EventTagDeleteResponse, type EventTagCreateParams as EventTagCreateParams, type EventTagDeleteParams as EventTagDeleteParams, };
}
//# sourceMappingURL=event-tags.d.ts.map