// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class EventTags extends APIResource {
    /**
     * Adds a tag to an event
     */
    create(eventId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cloudforce-one/events/event_tag/${eventId}/create`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Removes a tag from an event
     */
    delete(eventId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/cloudforce-one/events/event_tag/${eventId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=event-tags.mjs.map