"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Insights = void 0;
const resource_1 = require("../../../resource.js");
class Insights extends resource_1.APIResource {
    /**
     * Adds an insight to an event
     */
    create(eventId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cloudforce-one/events/${eventId}/insight/create`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes an event insight
     */
    delete(eventId, insightId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/cloudforce-one/events/${eventId}/insight/${insightId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an event insight
     */
    edit(eventId, insightId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/cloudforce-one/events/${eventId}/insight/${insightId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Reads an event insight
     */
    get(eventId, insightId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cloudforce-one/events/${eventId}/insight/${insightId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Insights = Insights;
//# sourceMappingURL=insights.js.map