import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class Settings extends APIResource {
    /**
     * Retrieve the current status of Content Scanning
     */
    get(params: SettingGetParams, options?: Core.RequestOptions): Core.APIPromise<SettingGetResponse>;
}
/**
 * The status for Content Scanning
 */
export interface SettingGetResponse {
    /**
     * Last modification date (ISO 8601) of the Content Scanning status
     */
    modified?: string;
    /**
     * Status of Content Scanning
     */
    value?: string;
}
export interface SettingGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Settings {
    export { type SettingGetResponse as SettingGetResponse, type SettingGetParams as SettingGetParams };
}
//# sourceMappingURL=settings.d.ts.map