import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as KeylessCertificatesAPI from "../keyless-certificates.js";
import * as PrioritizeAPI from "./prioritize.js";
import { Prioritize, PrioritizeUpdateParams } from "./prioritize.js";
import * as CustomHostnamesAPI from "../custom-hostnames/custom-hostnames.js";
import { SinglePage, V4PagePaginationArray, type V4PagePaginationArrayParams } from "../../pagination.js";
export declare class CustomCertificates extends APIResource {
    prioritize: PrioritizeAPI.Prioritize;
    /**
     * Upload a new SSL certificate for a zone.
     */
    create(params: CustomCertificateCreateParams, options?: Core.RequestOptions): Core.APIPromise<CustomCertificate>;
    /**
     * List, search, and filter all of your custom SSL certificates. The higher
     * priority will break ties across overlapping 'legacy_custom' certificates, but
     * 'legacy_custom' certificates will always supercede 'sni_custom' certificates.
     */
    list(params: CustomCertificateListParams, options?: Core.RequestOptions): Core.PagePromise<CustomCertificatesV4PagePaginationArray, CustomCertificate>;
    /**
     * Remove a SSL certificate from a zone.
     */
    delete(customCertificateId: string, params: CustomCertificateDeleteParams, options?: Core.RequestOptions): Core.APIPromise<CustomCertificateDeleteResponse>;
    /**
     * Upload a new private key and/or PEM/CRT for the SSL certificate. Note: PATCHing
     * a configuration for sni_custom certificates will result in a new resource id
     * being returned, and the previous one being deleted.
     */
    edit(customCertificateId: string, params: CustomCertificateEditParams, options?: Core.RequestOptions): Core.APIPromise<CustomCertificate>;
    /**
     * SSL Configuration Details
     */
    get(customCertificateId: string, params: CustomCertificateGetParams, options?: Core.RequestOptions): Core.APIPromise<CustomCertificate>;
}
export declare class CustomCertificatesV4PagePaginationArray extends V4PagePaginationArray<CustomCertificate> {
}
export declare class CustomCertificatesSinglePage extends SinglePage<CustomCertificate> {
}
export interface CustomCertificate {
    /**
     * Identifier
     */
    id: string;
    /**
     * A ubiquitous bundle has the highest probability of being verified everywhere,
     * even by clients using outdated or unusual trust stores. An optimal bundle uses
     * the shortest chain and newest intermediates. And the force bundle verifies the
     * chain, but does not otherwise modify it.
     */
    bundle_method: CustomHostnamesAPI.BundleMethod;
    /**
     * When the certificate from the authority expires.
     */
    expires_on: string;
    hosts: Array<string>;
    /**
     * The certificate authority that issued the certificate.
     */
    issuer: string;
    /**
     * When the certificate was last modified.
     */
    modified_on: string;
    /**
     * The order/priority in which the certificate will be used in a request. The
     * higher priority will break ties across overlapping 'legacy_custom' certificates,
     * but 'legacy_custom' certificates will always supercede 'sni_custom'
     * certificates.
     */
    priority: number;
    /**
     * The type of hash used for the certificate.
     */
    signature: string;
    /**
     * Status of the zone's custom SSL.
     */
    status: 'active' | 'expired' | 'deleted' | 'pending' | 'initializing';
    /**
     * When the certificate was uploaded to Cloudflare.
     */
    uploaded_on: string;
    /**
     * Identifier
     */
    zone_id: string;
    /**
     * Specify the region where your private key can be held locally for optimal TLS
     * performance. HTTPS connections to any excluded data center will still be fully
     * encrypted, but will incur some latency while Keyless SSL is used to complete the
     * handshake with the nearest allowed data center. Options allow distribution to
     * only to U.S. data centers, only to E.U. data centers, or only to highest
     * security data centers. Default distribution is to all Cloudflare datacenters,
     * for optimal performance.
     */
    geo_restrictions?: GeoRestrictions;
    keyless_server?: KeylessCertificatesAPI.KeylessCertificate;
    /**
     * Specify the policy that determines the region where your private key will be
     * held locally. HTTPS connections to any excluded data center will still be fully
     * encrypted, but will incur some latency while Keyless SSL is used to complete the
     * handshake with the nearest allowed data center. Any combination of countries,
     * specified by their two letter country code
     * (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
     * can be chosen, such as 'country: IN', as well as 'region: EU' which refers to
     * the EU region. If there are too few data centers satisfying the policy, it will
     * be rejected.
     */
    policy?: string;
}
/**
 * Specify the region where your private key can be held locally for optimal TLS
 * performance. HTTPS connections to any excluded data center will still be fully
 * encrypted, but will incur some latency while Keyless SSL is used to complete the
 * handshake with the nearest allowed data center. Options allow distribution to
 * only to U.S. data centers, only to E.U. data centers, or only to highest
 * security data centers. Default distribution is to all Cloudflare datacenters,
 * for optimal performance.
 */
export interface GeoRestrictions {
    label?: 'us' | 'eu' | 'highest_security';
}
/**
 * Specify the region where your private key can be held locally for optimal TLS
 * performance. HTTPS connections to any excluded data center will still be fully
 * encrypted, but will incur some latency while Keyless SSL is used to complete the
 * handshake with the nearest allowed data center. Options allow distribution to
 * only to U.S. data centers, only to E.U. data centers, or only to highest
 * security data centers. Default distribution is to all Cloudflare datacenters,
 * for optimal performance.
 */
export interface GeoRestrictionsParam {
    label?: 'us' | 'eu' | 'highest_security';
}
/**
 * Client Certificates may be active or revoked, and the pending_reactivation or
 * pending_revocation represent in-progress asynchronous transitions
 */
export type Status = 'active' | 'pending_reactivation' | 'pending_revocation' | 'revoked';
export interface CustomCertificateDeleteResponse {
    /**
     * Identifier
     */
    id?: string;
}
export interface CustomCertificateCreateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: The zone's SSL certificate or certificate and the intermediate(s).
     */
    certificate: string;
    /**
     * Body param: The zone's private key.
     */
    private_key: string;
    /**
     * Body param: A ubiquitous bundle has the highest probability of being verified
     * everywhere, even by clients using outdated or unusual trust stores. An optimal
     * bundle uses the shortest chain and newest intermediates. And the force bundle
     * verifies the chain, but does not otherwise modify it.
     */
    bundle_method?: CustomHostnamesAPI.BundleMethodParam;
    /**
     * Body param: Specify the region where your private key can be held locally for
     * optimal TLS performance. HTTPS connections to any excluded data center will
     * still be fully encrypted, but will incur some latency while Keyless SSL is used
     * to complete the handshake with the nearest allowed data center. Options allow
     * distribution to only to U.S. data centers, only to E.U. data centers, or only to
     * highest security data centers. Default distribution is to all Cloudflare
     * datacenters, for optimal performance.
     */
    geo_restrictions?: GeoRestrictionsParam;
    /**
     * Body param: Specify the policy that determines the region where your private key
     * will be held locally. HTTPS connections to any excluded data center will still
     * be fully encrypted, but will incur some latency while Keyless SSL is used to
     * complete the handshake with the nearest allowed data center. Any combination of
     * countries, specified by their two letter country code
     * (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
     * can be chosen, such as 'country: IN', as well as 'region: EU' which refers to
     * the EU region. If there are too few data centers satisfying the policy, it will
     * be rejected.
     */
    policy?: string;
    /**
     * Body param: The type 'legacy_custom' enables support for legacy clients which do
     * not include SNI in the TLS handshake.
     */
    type?: 'legacy_custom' | 'sni_custom';
}
export interface CustomCertificateListParams extends V4PagePaginationArrayParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Query param: Whether to match all search requirements or at least one (any).
     */
    match?: 'any' | 'all';
    /**
     * Query param: Status of the zone's custom SSL.
     */
    status?: 'active' | 'expired' | 'deleted' | 'pending' | 'initializing';
}
export interface CustomCertificateDeleteParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface CustomCertificateEditParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: A ubiquitous bundle has the highest probability of being verified
     * everywhere, even by clients using outdated or unusual trust stores. An optimal
     * bundle uses the shortest chain and newest intermediates. And the force bundle
     * verifies the chain, but does not otherwise modify it.
     */
    bundle_method?: CustomHostnamesAPI.BundleMethodParam;
    /**
     * Body param: The zone's SSL certificate or certificate and the intermediate(s).
     */
    certificate?: string;
    /**
     * Body param: Specify the region where your private key can be held locally for
     * optimal TLS performance. HTTPS connections to any excluded data center will
     * still be fully encrypted, but will incur some latency while Keyless SSL is used
     * to complete the handshake with the nearest allowed data center. Options allow
     * distribution to only to U.S. data centers, only to E.U. data centers, or only to
     * highest security data centers. Default distribution is to all Cloudflare
     * datacenters, for optimal performance.
     */
    geo_restrictions?: GeoRestrictionsParam;
    /**
     * Body param: Specify the policy that determines the region where your private key
     * will be held locally. HTTPS connections to any excluded data center will still
     * be fully encrypted, but will incur some latency while Keyless SSL is used to
     * complete the handshake with the nearest allowed data center. Any combination of
     * countries, specified by their two letter country code
     * (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
     * can be chosen, such as 'country: IN', as well as 'region: EU' which refers to
     * the EU region. If there are too few data centers satisfying the policy, it will
     * be rejected.
     */
    policy?: string;
    /**
     * Body param: The zone's private key.
     */
    private_key?: string;
}
export interface CustomCertificateGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace CustomCertificates {
    export { Prioritize as Prioritize, type PrioritizeUpdateParams as PrioritizeUpdateParams };
}
//# sourceMappingURL=custom-certificates.d.ts.map