"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomCertificatesSinglePage = exports.CustomCertificatesV4PagePaginationArray = exports.CustomCertificates = void 0;
const resource_1 = require("../../resource.js");
const PrioritizeAPI = __importStar(require("./prioritize.js"));
const prioritize_1 = require("./prioritize.js");
const pagination_1 = require("../../pagination.js");
class CustomCertificates extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.prioritize = new PrioritizeAPI.Prioritize(this._client);
    }
    /**
     * Upload a new SSL certificate for a zone.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/custom_certificates`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List, search, and filter all of your custom SSL certificates. The higher
     * priority will break ties across overlapping 'legacy_custom' certificates, but
     * 'legacy_custom' certificates will always supercede 'sni_custom' certificates.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/custom_certificates`, CustomCertificatesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Remove a SSL certificate from a zone.
     */
    delete(customCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/custom_certificates/${customCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Upload a new private key and/or PEM/CRT for the SSL certificate. Note: PATCHing
     * a configuration for sni_custom certificates will result in a new resource id
     * being returned, and the previous one being deleted.
     */
    edit(customCertificateId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/custom_certificates/${customCertificateId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * SSL Configuration Details
     */
    get(customCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/custom_certificates/${customCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.CustomCertificates = CustomCertificates;
class CustomCertificatesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.CustomCertificatesV4PagePaginationArray = CustomCertificatesV4PagePaginationArray;
class CustomCertificatesSinglePage extends pagination_1.SinglePage {
}
exports.CustomCertificatesSinglePage = CustomCertificatesSinglePage;
CustomCertificates.Prioritize = prioritize_1.Prioritize;
//# sourceMappingURL=custom-certificates.js.map