// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as PrioritizeAPI from "./prioritize.mjs";
import { Prioritize } from "./prioritize.mjs";
import { SinglePage, V4PagePaginationArray } from "../../pagination.mjs";
export class CustomCertificates extends APIResource {
    constructor() {
        super(...arguments);
        this.prioritize = new PrioritizeAPI.Prioritize(this._client);
    }
    /**
     * Upload a new SSL certificate for a zone.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/custom_certificates`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List, search, and filter all of your custom SSL certificates. The higher
     * priority will break ties across overlapping 'legacy_custom' certificates, but
     * 'legacy_custom' certificates will always supercede 'sni_custom' certificates.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/custom_certificates`, CustomCertificatesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Remove a SSL certificate from a zone.
     */
    delete(customCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/custom_certificates/${customCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Upload a new private key and/or PEM/CRT for the SSL certificate. Note: PATCHing
     * a configuration for sni_custom certificates will result in a new resource id
     * being returned, and the previous one being deleted.
     */
    edit(customCertificateId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/custom_certificates/${customCertificateId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * SSL Configuration Details
     */
    get(customCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/custom_certificates/${customCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class CustomCertificatesV4PagePaginationArray extends V4PagePaginationArray {
}
export class CustomCertificatesSinglePage extends SinglePage {
}
CustomCertificates.Prioritize = Prioritize;
//# sourceMappingURL=custom-certificates.mjs.map