import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as CustomCertificatesAPI from "./custom-certificates.js";
import { CustomCertificatesSinglePage } from "./custom-certificates.js";
export declare class Prioritize extends APIResource {
    /**
     * If a zone has multiple SSL certificates, you can set the order in which they
     * should be used during a request. The higher priority will break ties across
     * overlapping 'legacy_custom' certificates.
     */
    update(params: PrioritizeUpdateParams, options?: Core.RequestOptions): Core.PagePromise<CustomCertificatesSinglePage, CustomCertificatesAPI.CustomCertificate>;
}
export interface PrioritizeUpdateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: Array of ordered certificates.
     */
    certificates: Array<PrioritizeUpdateParams.Certificate>;
}
export declare namespace PrioritizeUpdateParams {
    interface Certificate {
        /**
         * Identifier
         */
        id?: string;
        /**
         * The order/priority in which the certificate will be used in a request. The
         * higher priority will break ties across overlapping 'legacy_custom' certificates,
         * but 'legacy_custom' certificates will always supercede 'sni_custom'
         * certificates.
         */
        priority?: number;
    }
}
export declare namespace Prioritize {
    export { type PrioritizeUpdateParams as PrioritizeUpdateParams };
}
export { CustomCertificatesSinglePage };
//# sourceMappingURL=prioritize.d.ts.map