// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Certificates extends APIResource {
    /**
     * Replace a single custom certificate within a certificate pack that contains two
     * bundled certificates. The replacement must adhere to the following constraints.
     * You can only replace an RSA certificate with another RSA certificate or an ECDSA
     * certificate with another ECDSA certificate.
     */
    update(customHostnameId, certificatePackId, certificateId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/custom_hostnames/${customHostnameId}/certificate_pack/${certificatePackId}/certificates/${certificateId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete a single custom certificate from a certificate pack that contains two
     * bundled certificates. Deletion is subject to the following constraints. You
     * cannot delete a certificate if it is the only remaining certificate in the pack.
     * At least one certificate must remain in the pack.
     */
    delete(customHostnameId, certificatePackId, certificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/custom_hostnames/${customHostnameId}/certificate_pack/${certificatePackId}/certificates/${certificateId}`, options);
    }
}
//# sourceMappingURL=certificates.mjs.map