import { APIResource } from "../resource.js";
import * as Core from "../core.js";
import { SinglePage } from "../pagination.js";
export declare class CustomNameservers extends APIResource {
    /**
     * Add Account Custom Nameserver
     */
    create(params: CustomNameserverCreateParams, options?: Core.RequestOptions): Core.APIPromise<CustomNameserver>;
    /**
     * Delete Account Custom Nameserver
     */
    delete(customNSId: string, params: CustomNameserverDeleteParams, options?: Core.RequestOptions): Core.PagePromise<CustomNameserverDeleteResponsesSinglePage, CustomNameserverDeleteResponse>;
    /**
     * Get Eligible Zones for Account Custom Nameservers
     */
    availabilty(params: CustomNameserverAvailabiltyParams, options?: Core.RequestOptions): Core.PagePromise<CustomNameserverAvailabiltyResponsesSinglePage, CustomNameserverAvailabiltyResponse>;
    /**
     * List an account's custom nameservers.
     */
    get(params: CustomNameserverGetParams, options?: Core.RequestOptions): Core.PagePromise<CustomNameserversSinglePage, CustomNameserver>;
}
export declare class CustomNameserverDeleteResponsesSinglePage extends SinglePage<CustomNameserverDeleteResponse> {
}
export declare class CustomNameserverAvailabiltyResponsesSinglePage extends SinglePage<CustomNameserverAvailabiltyResponse> {
}
export declare class CustomNameserversSinglePage extends SinglePage<CustomNameserver> {
}
/**
 * A single account custom nameserver.
 */
export interface CustomNameserver {
    /**
     * A and AAAA records associated with the nameserver.
     */
    dns_records: Array<CustomNameserver.DNSRecord>;
    /**
     * The FQDN of the name server.
     */
    ns_name: string;
    /**
     * @deprecated Verification status of the nameserver.
     */
    status: 'moved' | 'pending' | 'verified';
    /**
     * Identifier
     */
    zone_tag: string;
    /**
     * The number of the set that this name server belongs to.
     */
    ns_set?: number;
}
export declare namespace CustomNameserver {
    interface DNSRecord {
        /**
         * DNS record type.
         */
        type?: 'A' | 'AAAA';
        /**
         * DNS record contents (an IPv4 or IPv6 address).
         */
        value?: string;
    }
}
/**
 * Unused
 */
export type CustomNameserverDeleteResponse = string;
/**
 * Name of zone based on which account custom nameservers can be created. For
 * example, if example.com is returned, then ns1.example.com can be used as an
 * account custom nameserver.
 */
export type CustomNameserverAvailabiltyResponse = string;
export interface CustomNameserverCreateParams {
    /**
     * Path param: Account identifier tag.
     */
    account_id: string;
    /**
     * Body param: The FQDN of the name server.
     */
    ns_name: string;
    /**
     * Body param: The number of the set that this name server belongs to.
     */
    ns_set?: number;
}
export interface CustomNameserverDeleteParams {
    /**
     * Account identifier tag.
     */
    account_id: string;
}
export interface CustomNameserverAvailabiltyParams {
    /**
     * Account identifier tag.
     */
    account_id: string;
}
export interface CustomNameserverGetParams {
    /**
     * Account identifier tag.
     */
    account_id: string;
}
//# sourceMappingURL=custom-nameservers.d.ts.map