"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomNameserversSinglePage = exports.CustomNameserverAvailabiltyResponsesSinglePage = exports.CustomNameserverDeleteResponsesSinglePage = exports.CustomNameservers = void 0;
const resource_1 = require("../resource.js");
const pagination_1 = require("../pagination.js");
class CustomNameservers extends resource_1.APIResource {
    /**
     * Add Account Custom Nameserver
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/custom_ns`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete Account Custom Nameserver
     */
    delete(customNSId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/custom_ns/${customNSId}`, CustomNameserverDeleteResponsesSinglePage, { method: 'delete', ...options });
    }
    /**
     * Get Eligible Zones for Account Custom Nameservers
     */
    availabilty(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/custom_ns/availability`, CustomNameserverAvailabiltyResponsesSinglePage, options);
    }
    /**
     * List an account's custom nameservers.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/custom_ns`, CustomNameserversSinglePage, options);
    }
}
exports.CustomNameservers = CustomNameservers;
class CustomNameserverDeleteResponsesSinglePage extends pagination_1.SinglePage {
}
exports.CustomNameserverDeleteResponsesSinglePage = CustomNameserverDeleteResponsesSinglePage;
class CustomNameserverAvailabiltyResponsesSinglePage extends pagination_1.SinglePage {
}
exports.CustomNameserverAvailabiltyResponsesSinglePage = CustomNameserverAvailabiltyResponsesSinglePage;
class CustomNameserversSinglePage extends pagination_1.SinglePage {
}
exports.CustomNameserversSinglePage = CustomNameserversSinglePage;
//# sourceMappingURL=custom-nameservers.js.map