// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../resource.mjs";
import { SinglePage } from "../pagination.mjs";
export class CustomNameservers extends APIResource {
    /**
     * Add Account Custom Nameserver
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/custom_ns`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete Account Custom Nameserver
     */
    delete(customNSId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/custom_ns/${customNSId}`, CustomNameserverDeleteResponsesSinglePage, { method: 'delete', ...options });
    }
    /**
     * Get Eligible Zones for Account Custom Nameservers
     */
    availabilty(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/custom_ns/availability`, CustomNameserverAvailabiltyResponsesSinglePage, options);
    }
    /**
     * List an account's custom nameservers.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/custom_ns`, CustomNameserversSinglePage, options);
    }
}
export class CustomNameserverDeleteResponsesSinglePage extends SinglePage {
}
export class CustomNameserverAvailabiltyResponsesSinglePage extends SinglePage {
}
export class CustomNameserversSinglePage extends SinglePage {
}
//# sourceMappingURL=custom-nameservers.mjs.map