import { APIResource } from "../resource.js";
import * as Core from "../core.js";
import { SinglePage } from "../pagination.js";
export declare class CustomPages extends APIResource {
    /**
     * Updates the configuration of an existing custom page.
     */
    update(identifier: string, params: CustomPageUpdateParams, options?: Core.RequestOptions): Core.APIPromise<CustomPageUpdateResponse | null>;
    /**
     * Fetches all the custom pages.
     */
    list(params?: CustomPageListParams, options?: Core.RequestOptions): Core.PagePromise<CustomPageListResponsesSinglePage, CustomPageListResponse>;
    list(options?: Core.RequestOptions): Core.PagePromise<CustomPageListResponsesSinglePage, CustomPageListResponse>;
    /**
     * Fetches the details of a custom page.
     */
    get(identifier: string, params?: CustomPageGetParams, options?: Core.RequestOptions): Core.APIPromise<CustomPageGetResponse | null>;
    get(identifier: string, options?: Core.RequestOptions): Core.APIPromise<CustomPageGetResponse | null>;
}
export declare class CustomPageListResponsesSinglePage extends SinglePage<CustomPageListResponse> {
}
export type CustomPageUpdateResponse = unknown | string;
export type CustomPageListResponse = unknown;
export type CustomPageGetResponse = unknown | string;
export interface CustomPageUpdateParams {
    /**
     * Body param: The custom page state.
     */
    state: 'default' | 'customized';
    /**
     * Body param: The URL associated with the custom page.
     */
    url: string;
    /**
     * Path param: The Account ID to use for this endpoint. Mutually exclusive with the
     * Zone ID.
     */
    account_id?: string;
    /**
     * Path param: The Zone ID to use for this endpoint. Mutually exclusive with the
     * Account ID.
     */
    zone_id?: string;
}
export interface CustomPageListParams {
    /**
     * The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
     */
    account_id?: string;
    /**
     * The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
     */
    zone_id?: string;
}
export interface CustomPageGetParams {
    /**
     * The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
     */
    account_id?: string;
    /**
     * The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
     */
    zone_id?: string;
}
//# sourceMappingURL=custom-pages.d.ts.map