"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseRawResponsesSinglePage = exports.QueryResultsSinglePage = exports.DatabaseListResponsesV4PagePaginationArray = exports.Database = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Database extends resource_1.APIResource {
    /**
     * Returns the created D1 database.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/d1/database`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns a list of D1 databases.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/d1/database`, DatabaseListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletes the specified D1 database.
     */
    delete(databaseId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/d1/database/${databaseId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns a URL where the SQL contents of your D1 can be downloaded. Note: this
     * process may take some time for larger DBs, during which your D1 will be
     * unavailable to serve queries. To avoid blocking your DB unnecessarily, an
     * in-progress export must be continually polled or will automatically cancel.
     */
    export(databaseId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/d1/database/${databaseId}/export`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns the specified D1 database.
     */
    get(databaseId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/d1/database/${databaseId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Generates a temporary URL for uploading an SQL file to, then instructing the D1
     * to import it and polling it for status updates. Imports block the D1 for their
     * duration.
     */
    import(databaseId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/d1/database/${databaseId}/import`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns the query result as an object.
     */
    query(databaseId, params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/d1/database/${databaseId}/query`, QueryResultsSinglePage, { body, method: 'post', ...options });
    }
    /**
     * Returns the query result rows as arrays rather than objects. This is a
     * performance-optimized version of the /query endpoint.
     */
    raw(databaseId, params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/d1/database/${databaseId}/raw`, DatabaseRawResponsesSinglePage, { body, method: 'post', ...options });
    }
}
exports.Database = Database;
class DatabaseListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.DatabaseListResponsesV4PagePaginationArray = DatabaseListResponsesV4PagePaginationArray;
class QueryResultsSinglePage extends pagination_1.SinglePage {
}
exports.QueryResultsSinglePage = QueryResultsSinglePage;
class DatabaseRawResponsesSinglePage extends pagination_1.SinglePage {
}
exports.DatabaseRawResponsesSinglePage = DatabaseRawResponsesSinglePage;
Database.DatabaseListResponsesV4PagePaginationArray = DatabaseListResponsesV4PagePaginationArray;
Database.QueryResultsSinglePage = QueryResultsSinglePage;
Database.DatabaseRawResponsesSinglePage = DatabaseRawResponsesSinglePage;
//# sourceMappingURL=database.js.map