// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as ReverseDNSAPI from "./reverse-dns.mjs";
import { ReverseDNS, } from "./reverse-dns.mjs";
import * as AnalyticsAPI from "./analytics/analytics.mjs";
import { Analytics } from "./analytics/analytics.mjs";
import { V4PagePaginationArray } from "../../pagination.mjs";
export class DNSFirewall extends APIResource {
    constructor() {
        super(...arguments);
        this.analytics = new AnalyticsAPI.Analytics(this._client);
        this.reverseDNS = new ReverseDNSAPI.ReverseDNS(this._client);
    }
    /**
     * Create a DNS Firewall cluster
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/dns_firewall`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List DNS Firewall clusters for an account
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/dns_firewall`, DNSFirewallListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a DNS Firewall cluster
     */
    delete(dnsFirewallId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/dns_firewall/${dnsFirewallId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Modify the configuration of a DNS Firewall cluster
     */
    edit(dnsFirewallId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/dns_firewall/${dnsFirewallId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Show a single DNS Firewall cluster for an account
     */
    get(dnsFirewallId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dns_firewall/${dnsFirewallId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DNSFirewallListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
DNSFirewall.Analytics = Analytics;
DNSFirewall.ReverseDNS = ReverseDNS;
//# sourceMappingURL=dns-firewall.mjs.map