"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReverseDNS = void 0;
const resource_1 = require("../../resource.js");
class ReverseDNS extends resource_1.APIResource {
    /**
     * Update reverse DNS configuration (PTR records) for a DNS Firewall cluster
     */
    edit(dnsFirewallId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/dns_firewall/${dnsFirewallId}/reverse_dns`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Show reverse DNS configuration (PTR records) for a DNS Firewall cluster
     */
    get(dnsFirewallId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dns_firewall/${dnsFirewallId}/reverse_dns`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.ReverseDNS = ReverseDNS;
//# sourceMappingURL=reverse-dns.js.map