"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecordResponsesV4PagePaginationArray = exports.Records = void 0;
const resource_1 = require("../../resource.js");
const Core = __importStar(require("../../core.js"));
const pagination_1 = require("../../pagination.js");
class Records extends resource_1.APIResource {
    /**
     * Create a new DNS record for a zone.
     *
     * Notes:
     *
     * - A/AAAA records cannot exist on the same name as CNAME records.
     * - NS records cannot exist on the same name as any other record type.
     * - Domain names are always represented in Punycode, even if Unicode characters
     *   were used when creating the record.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/dns_records`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Overwrite an existing DNS record.
     *
     * Notes:
     *
     * - A/AAAA records cannot exist on the same name as CNAME records.
     * - NS records cannot exist on the same name as any other record type.
     * - Domain names are always represented in Punycode, even if Unicode characters
     *   were used when creating the record.
     */
    update(dnsRecordId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/dns_records/${dnsRecordId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List, search, sort, and filter a zones' DNS records.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/dns_records`, RecordResponsesV4PagePaginationArray, {
            query,
            ...options,
        });
    }
    /**
     * Delete DNS Record
     */
    delete(dnsRecordId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/dns_records/${dnsRecordId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Send a Batch of DNS Record API calls to be executed together.
     *
     * Notes:
     *
     * - Although Cloudflare will execute the batched operations in a single database
     *   transaction, Cloudflare's distributed KV store must treat each record change
     *   as a single key-value pair. This means that the propagation of changes is not
     *   atomic. See
     *   [the documentation](https://developers.cloudflare.com/dns/manage-dns-records/how-to/batch-record-changes/ "Batch DNS records")
     *   for more information.
     * - The operations you specify within the /batch request body are always executed
     *   in the following order:
     *
     *   - Deletes
     *   - Patches
     *   - Puts
     *   - Posts
     */
    batch(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/dns_records/batch`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update an existing DNS record.
     *
     * Notes:
     *
     * - A/AAAA records cannot exist on the same name as CNAME records.
     * - NS records cannot exist on the same name as any other record type.
     * - Domain names are always represented in Punycode, even if Unicode characters
     *   were used when creating the record.
     */
    edit(dnsRecordId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/dns_records/${dnsRecordId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * You can export your
     * [BIND config](https://en.wikipedia.org/wiki/Zone_file "Zone file") through this
     * endpoint.
     *
     * See
     * [the documentation](https://developers.cloudflare.com/dns/manage-dns-records/how-to/import-and-export/ "Import and export records")
     * for more information.
     */
    export(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/dns_records/export`, {
            ...options,
            headers: { Accept: 'text/plain', ...options?.headers },
        });
    }
    /**
     * DNS Record Details
     */
    get(dnsRecordId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/dns_records/${dnsRecordId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * You can upload your
     * [BIND config](https://en.wikipedia.org/wiki/Zone_file "Zone file") through this
     * endpoint. It assumes that cURL is called from a location with bind_config.txt
     * (valid BIND config) present.
     *
     * See
     * [the documentation](https://developers.cloudflare.com/dns/manage-dns-records/how-to/import-and-export/ "Import and export records")
     * for more information.
     */
    import(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/dns_records/import`, Core.multipartFormRequestOptions({ body, ...options }))._thenUnwrap((obj) => obj.result);
    }
    /**
     * Scan for common DNS records on your domain and automatically add them to your
     * zone. Useful if you haven't updated your nameservers yet.
     */
    scan(params, options) {
        const { zone_id, body } = params;
        return this._client.post(`/zones/${zone_id}/dns_records/scan`, { body: body, ...options })._thenUnwrap((obj) => obj.result);
    }
}
exports.Records = Records;
class RecordResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.RecordResponsesV4PagePaginationArray = RecordResponsesV4PagePaginationArray;
Records.RecordResponsesV4PagePaginationArray = RecordResponsesV4PagePaginationArray;
//# sourceMappingURL=records.js.map