// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import { V4PagePaginationArray } from "../../../../pagination.mjs";
export class Views extends APIResource {
    /**
     * Create Internal DNS View for an account
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/dns_settings/views`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List DNS Internal Views for an Account
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/dns_settings/views`, ViewListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete an existing Internal DNS View
     */
    delete(viewId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/dns_settings/views/${viewId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update an existing Internal DNS View
     */
    edit(viewId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/dns_settings/views/${viewId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get DNS Internal View
     */
    get(viewId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dns_settings/views/${viewId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ViewListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
Views.ViewListResponsesV4PagePaginationArray = ViewListResponsesV4PagePaginationArray;
//# sourceMappingURL=views.mjs.map