"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ACLsSinglePage = exports.ACLs = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class ACLs extends resource_1.APIResource {
    /**
     * Create ACL.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/secondary_dns/acls`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Modify ACL.
     */
    update(aclId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/secondary_dns/acls/${aclId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List ACLs.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/secondary_dns/acls`, ACLsSinglePage, options);
    }
    /**
     * Delete ACL.
     */
    delete(aclId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/secondary_dns/acls/${aclId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get ACL.
     */
    get(aclId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/secondary_dns/acls/${aclId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.ACLs = ACLs;
class ACLsSinglePage extends pagination_1.SinglePage {
}
exports.ACLsSinglePage = ACLsSinglePage;
ACLs.ACLsSinglePage = ACLsSinglePage;
//# sourceMappingURL=acls.js.map