// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class ACLs extends APIResource {
    /**
     * Create ACL.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/secondary_dns/acls`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Modify ACL.
     */
    update(aclId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/secondary_dns/acls/${aclId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List ACLs.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/secondary_dns/acls`, ACLsSinglePage, options);
    }
    /**
     * Delete ACL.
     */
    delete(aclId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/secondary_dns/acls/${aclId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get ACL.
     */
    get(aclId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/secondary_dns/acls/${aclId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ACLsSinglePage extends SinglePage {
}
ACLs.ACLsSinglePage = ACLsSinglePage;
//# sourceMappingURL=acls.mjs.map