"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncomingResource = void 0;
const resource_1 = require("../../../resource.js");
class IncomingResource extends resource_1.APIResource {
    /**
     * Create secondary zone configuration for incoming zone transfers.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/secondary_dns/incoming`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update secondary zone configuration for incoming zone transfers.
     */
    update(params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/secondary_dns/incoming`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete secondary zone configuration for incoming zone transfers.
     */
    delete(params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/secondary_dns/incoming`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get secondary zone configuration for incoming zone transfers.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/secondary_dns/incoming`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.IncomingResource = IncomingResource;
//# sourceMappingURL=incoming.js.map