// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class IncomingResource extends APIResource {
    /**
     * Create secondary zone configuration for incoming zone transfers.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/secondary_dns/incoming`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update secondary zone configuration for incoming zone transfers.
     */
    update(params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/secondary_dns/incoming`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete secondary zone configuration for incoming zone transfers.
     */
    delete(params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/secondary_dns/incoming`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get secondary zone configuration for incoming zone transfers.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/secondary_dns/incoming`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=incoming.mjs.map