// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as StatusAPI from "./status.mjs";
import { Status } from "./status.mjs";
export class OutgoingResource extends APIResource {
    constructor() {
        super(...arguments);
        this.status = new StatusAPI.Status(this._client);
    }
    /**
     * Create primary zone configuration for outgoing zone transfers.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/secondary_dns/outgoing`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update primary zone configuration for outgoing zone transfers.
     */
    update(params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/secondary_dns/outgoing`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete primary zone configuration for outgoing zone transfers.
     */
    delete(params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/secondary_dns/outgoing`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Disable outgoing zone transfers for primary zone and clears IXFR backlog of
     * primary zone.
     */
    disable(params, options) {
        const { zone_id, body } = params;
        return this._client.post(`/zones/${zone_id}/secondary_dns/outgoing/disable`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Enable outgoing zone transfers for primary zone.
     */
    enable(params, options) {
        const { zone_id, body } = params;
        return this._client.post(`/zones/${zone_id}/secondary_dns/outgoing/enable`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Notifies the secondary nameserver(s) and clears IXFR backlog of primary zone.
     */
    forceNotify(params, options) {
        const { zone_id, body } = params;
        return this._client.post(`/zones/${zone_id}/secondary_dns/outgoing/force_notify`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get primary zone configuration for outgoing zone transfers.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/secondary_dns/outgoing`, options)._thenUnwrap((obj) => obj.result);
    }
}
OutgoingResource.Status = Status;
//# sourceMappingURL=outgoing.mjs.map