import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class TSIGs extends APIResource {
    /**
     * Create TSIG.
     */
    create(params: TSIGCreateParams, options?: Core.RequestOptions): Core.APIPromise<TSIG>;
    /**
     * Modify TSIG.
     */
    update(tsigId: string, params: TSIGUpdateParams, options?: Core.RequestOptions): Core.APIPromise<TSIG>;
    /**
     * List TSIGs.
     */
    list(params: TSIGListParams, options?: Core.RequestOptions): Core.PagePromise<TSIGsSinglePage, TSIG>;
    /**
     * Delete TSIG.
     */
    delete(tsigId: string, params: TSIGDeleteParams, options?: Core.RequestOptions): Core.APIPromise<TSIGDeleteResponse>;
    /**
     * Get TSIG.
     */
    get(tsigId: string, params: TSIGGetParams, options?: Core.RequestOptions): Core.APIPromise<TSIG>;
}
export declare class TSIGsSinglePage extends SinglePage<TSIG> {
}
export interface TSIG {
    id: string;
    /**
     * TSIG algorithm.
     */
    algo: string;
    /**
     * TSIG key name.
     */
    name: string;
    /**
     * TSIG secret.
     */
    secret: string;
}
export interface TSIGDeleteResponse {
    id?: string;
}
export interface TSIGCreateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: TSIG algorithm.
     */
    algo: string;
    /**
     * Body param: TSIG key name.
     */
    name: string;
    /**
     * Body param: TSIG secret.
     */
    secret: string;
}
export interface TSIGUpdateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: TSIG algorithm.
     */
    algo: string;
    /**
     * Body param: TSIG key name.
     */
    name: string;
    /**
     * Body param: TSIG secret.
     */
    secret: string;
}
export interface TSIGListParams {
    account_id: string;
}
export interface TSIGDeleteParams {
    account_id: string;
}
export interface TSIGGetParams {
    account_id: string;
}
export declare namespace TSIGs {
    export { type TSIG as TSIG, type TSIGDeleteResponse as TSIGDeleteResponse, TSIGsSinglePage as TSIGsSinglePage, type TSIGCreateParams as TSIGCreateParams, type TSIGUpdateParams as TSIGUpdateParams, type TSIGListParams as TSIGListParams, type TSIGDeleteParams as TSIGDeleteParams, type TSIGGetParams as TSIGGetParams, };
}
//# sourceMappingURL=tsigs.d.ts.map