"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TSIGsSinglePage = exports.TSIGs = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class TSIGs extends resource_1.APIResource {
    /**
     * Create TSIG.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/secondary_dns/tsigs`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Modify TSIG.
     */
    update(tsigId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/secondary_dns/tsigs/${tsigId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List TSIGs.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/secondary_dns/tsigs`, TSIGsSinglePage, options);
    }
    /**
     * Delete TSIG.
     */
    delete(tsigId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/secondary_dns/tsigs/${tsigId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get TSIG.
     */
    get(tsigId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/secondary_dns/tsigs/${tsigId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.TSIGs = TSIGs;
class TSIGsSinglePage extends pagination_1.SinglePage {
}
exports.TSIGsSinglePage = TSIGsSinglePage;
TSIGs.TSIGsSinglePage = TSIGsSinglePage;
//# sourceMappingURL=tsigs.js.map