"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddressesV4PagePaginationArray = exports.Addresses = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Addresses extends resource_1.APIResource {
    /**
     * Create a destination address to forward your emails to. Destination addresses
     * need to be verified before they can be used.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email/routing/addresses`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists existing destination addresses.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email/routing/addresses`, AddressesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletes a specific destination address.
     */
    delete(destinationAddressIdentifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email/routing/addresses/${destinationAddressIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets information for a specific destination email already created.
     */
    get(destinationAddressIdentifier, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email/routing/addresses/${destinationAddressIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Addresses = Addresses;
class AddressesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.AddressesV4PagePaginationArray = AddressesV4PagePaginationArray;
Addresses.AddressesV4PagePaginationArray = AddressesV4PagePaginationArray;
//# sourceMappingURL=addresses.js.map