// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { V4PagePaginationArray } from "../../pagination.mjs";
export class Addresses extends APIResource {
    /**
     * Create a destination address to forward your emails to. Destination addresses
     * need to be verified before they can be used.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email/routing/addresses`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists existing destination addresses.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email/routing/addresses`, AddressesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletes a specific destination address.
     */
    delete(destinationAddressIdentifier, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email/routing/addresses/${destinationAddressIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets information for a specific destination email already created.
     */
    get(destinationAddressIdentifier, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email/routing/addresses/${destinationAddressIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class AddressesV4PagePaginationArray extends V4PagePaginationArray {
}
Addresses.AddressesV4PagePaginationArray = AddressesV4PagePaginationArray;
//# sourceMappingURL=addresses.mjs.map