"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DNSRecordsSinglePage = exports.DNS = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class DNS extends resource_1.APIResource {
    /**
     * Enable you Email Routing zone. Add and lock the necessary MX and SPF records.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/email/routing/dns`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Disable your Email Routing zone. Also removes additional MX records previously
     * required for Email Routing to work.
     */
    delete(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/email/routing/dns`, DNSRecordsSinglePage, {
            method: 'delete',
            ...options,
        });
    }
    /**
     * Unlock MX Records previously locked by Email Routing.
     */
    edit(params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/email/routing/dns`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Show the DNS records needed to configure your Email Routing zone.
     */
    get(params, options) {
        const { zone_id, ...query } = params;
        return this._client.get(`/zones/${zone_id}/email/routing/dns`, { query, ...options });
    }
}
exports.DNS = DNS;
class DNSRecordsSinglePage extends pagination_1.SinglePage {
}
exports.DNSRecordsSinglePage = DNSRecordsSinglePage;
DNS.DNSRecordsSinglePage = DNSRecordsSinglePage;
//# sourceMappingURL=dns.js.map