"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.CatchAlls = void 0;
const resource_1 = require("../../../resource.js");
class CatchAlls extends resource_1.APIResource {
    /**
     * Enable or disable catch-all routing rule, or change action to forward to
     * specific destination address.
     */
    update(params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/email/routing/rules/catch_all`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get information on the default catch-all routing rule.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/email/routing/rules/catch_all`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.CatchAlls = CatchAlls;
//# sourceMappingURL=catch-alls.js.map