import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class Move extends APIResource {
    /**
     * Move a message
     */
    create(postfixId: string, params: MoveCreateParams, options?: Core.RequestOptions): Core.PagePromise<MoveCreateResponsesSinglePage, MoveCreateResponse>;
    /**
     * Move multiple messages
     */
    bulk(params: MoveBulkParams, options?: Core.RequestOptions): Core.PagePromise<MoveBulkResponsesSinglePage, MoveBulkResponse>;
}
export declare class MoveCreateResponsesSinglePage extends SinglePage<MoveCreateResponse> {
}
export declare class MoveBulkResponsesSinglePage extends SinglePage<MoveBulkResponse> {
}
export interface MoveCreateResponse {
    completed_timestamp: string;
    destination: string;
    item_count: number;
    message_id: string;
    operation: string;
    recipient: string;
    status: string;
}
export interface MoveBulkResponse {
    completed_timestamp: string;
    destination: string;
    item_count: number;
    message_id: string;
    operation: string;
    recipient: string;
    status: string;
}
export interface MoveCreateParams {
    /**
     * Path param: Account Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    destination: 'Inbox' | 'JunkEmail' | 'DeletedItems' | 'RecoverableItemsDeletions' | 'RecoverableItemsPurges';
}
export interface MoveBulkParams {
    /**
     * Path param: Account Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    destination: 'Inbox' | 'JunkEmail' | 'DeletedItems' | 'RecoverableItemsDeletions' | 'RecoverableItemsPurges';
    /**
     * Body param:
     */
    postfix_ids: Array<string>;
}
export declare namespace Move {
    export { type MoveCreateResponse as MoveCreateResponse, type MoveBulkResponse as MoveBulkResponse, MoveCreateResponsesSinglePage as MoveCreateResponsesSinglePage, MoveBulkResponsesSinglePage as MoveBulkResponsesSinglePage, type MoveCreateParams as MoveCreateParams, type MoveBulkParams as MoveBulkParams, };
}
//# sourceMappingURL=move.d.ts.map