// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Move extends APIResource {
    /**
     * Move a message
     */
    create(postfixId, params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/investigate/${postfixId}/move`, MoveCreateResponsesSinglePage, { body, method: 'post', ...options });
    }
    /**
     * Move multiple messages
     */
    bulk(params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/investigate/move`, MoveBulkResponsesSinglePage, { body, method: 'post', ...options });
    }
}
export class MoveCreateResponsesSinglePage extends SinglePage {
}
export class MoveBulkResponsesSinglePage extends SinglePage {
}
Move.MoveCreateResponsesSinglePage = MoveCreateResponsesSinglePage;
Move.MoveBulkResponsesSinglePage = MoveBulkResponsesSinglePage;
//# sourceMappingURL=move.mjs.map