"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Preview = void 0;
const resource_1 = require("../../../resource.js");
class Preview extends resource_1.APIResource {
    /**
     * Preview for non-detection messages
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email-security/investigate/preview`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns a preview of the message body as a base64 encoded PNG image for
     * non-benign messages.
     */
    get(postfixId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/investigate/${postfixId}/preview`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Preview = Preview;
//# sourceMappingURL=preview.js.map