// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Preview extends APIResource {
    /**
     * Preview for non-detection messages
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email-security/investigate/preview`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns a preview of the message body as a base64 encoded PNG image for
     * non-benign messages.
     */
    get(postfixId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/investigate/${postfixId}/preview`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=preview.mjs.map