"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.BlockSenderListResponsesV4PagePaginationArray = exports.BlockSenders = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class BlockSenders extends resource_1.APIResource {
    /**
     * Create a blocked email sender
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email-security/settings/block_senders`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List blocked email senders
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/block_senders`, BlockSenderListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a blocked email sender
     */
    delete(patternId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email-security/settings/block_senders/${patternId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a blocked email sender
     */
    edit(patternId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/email-security/settings/block_senders/${patternId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a blocked email sender
     */
    get(patternId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/settings/block_senders/${patternId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.BlockSenders = BlockSenders;
class BlockSenderListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.BlockSenderListResponsesV4PagePaginationArray = BlockSenderListResponsesV4PagePaginationArray;
BlockSenders.BlockSenderListResponsesV4PagePaginationArray = BlockSenderListResponsesV4PagePaginationArray;
//# sourceMappingURL=block-senders.js.map