// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { V4PagePaginationArray } from "../../../pagination.mjs";
export class BlockSenders extends APIResource {
    /**
     * Create a blocked email sender
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email-security/settings/block_senders`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List blocked email senders
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/block_senders`, BlockSenderListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a blocked email sender
     */
    delete(patternId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email-security/settings/block_senders/${patternId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a blocked email sender
     */
    edit(patternId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/email-security/settings/block_senders/${patternId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a blocked email sender
     */
    get(patternId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/settings/block_senders/${patternId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class BlockSenderListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
BlockSenders.BlockSenderListResponsesV4PagePaginationArray = BlockSenderListResponsesV4PagePaginationArray;
//# sourceMappingURL=block-senders.mjs.map