"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainBulkDeleteResponsesSinglePage = exports.DomainListResponsesV4PagePaginationArray = exports.Domains = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Domains extends resource_1.APIResource {
    /**
     * Lists, searches, and sorts an account’s email domains.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/domains`, DomainListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Unprotect an email domain
     */
    delete(domainId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email-security/settings/domains/${domainId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Unprotect multiple email domains
     */
    bulkDelete(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/domains`, DomainBulkDeleteResponsesSinglePage, { method: 'delete', ...options });
    }
    /**
     * Update an email domain
     */
    edit(domainId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/email-security/settings/domains/${domainId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get an email domain
     */
    get(domainId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/settings/domains/${domainId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Domains = Domains;
class DomainListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.DomainListResponsesV4PagePaginationArray = DomainListResponsesV4PagePaginationArray;
class DomainBulkDeleteResponsesSinglePage extends pagination_1.SinglePage {
}
exports.DomainBulkDeleteResponsesSinglePage = DomainBulkDeleteResponsesSinglePage;
Domains.DomainListResponsesV4PagePaginationArray = DomainListResponsesV4PagePaginationArray;
Domains.DomainBulkDeleteResponsesSinglePage = DomainBulkDeleteResponsesSinglePage;
//# sourceMappingURL=domains.js.map