// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage, V4PagePaginationArray } from "../../../pagination.mjs";
export class Domains extends APIResource {
    /**
     * Lists, searches, and sorts an account’s email domains.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/domains`, DomainListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Unprotect an email domain
     */
    delete(domainId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email-security/settings/domains/${domainId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Unprotect multiple email domains
     */
    bulkDelete(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/domains`, DomainBulkDeleteResponsesSinglePage, { method: 'delete', ...options });
    }
    /**
     * Update an email domain
     */
    edit(domainId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/email-security/settings/domains/${domainId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get an email domain
     */
    get(domainId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/settings/domains/${domainId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DomainListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
export class DomainBulkDeleteResponsesSinglePage extends SinglePage {
}
Domains.DomainListResponsesV4PagePaginationArray = DomainListResponsesV4PagePaginationArray;
Domains.DomainBulkDeleteResponsesSinglePage = DomainBulkDeleteResponsesSinglePage;
//# sourceMappingURL=domains.mjs.map